<?php

declare(strict_types=1);

namespace Controllers;

abstract class BaseController
{
    protected function requireAuth(): int
    {
        if (empty($_SESSION['user_id'])) {
            $this->redirect('/login');
            exit;
        }
        return (int) $_SESSION['user_id'];
    }

    protected function view(string $name, array $data = []): void
    {
        $data['_user_id'] = $_SESSION['user_id'] ?? null;
        $data['_user_email'] = $_SESSION['user_email'] ?? null;
        $data['base'] = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
        $data['_view_path'] = __DIR__ . '/../views/' . $name . '.php';
        extract($data);
        require __DIR__ . '/../views/layout.php';
    }

    protected function redirect(string $path): void
    {
        $base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
        header('Location: ' . $base . $path);
        exit;
    }

    protected function json(array $data): void
    {
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data);
        exit;
    }
}
