<?php

declare(strict_types=1);

namespace Controllers;

use Models\Exercise;
use Models\Comment;

class ExerciseController extends BaseController
{
    public function index(): void
    {
        $this->requireAuth();
        $exerciseModel = new Exercise();
        $exercises = $exerciseModel->allWithDecoded();

        $this->view('exercises/index', [
            'title' => 'Exercise Library',
            'exercises' => $exercises,
        ]);
    }

    public function show(): void
    {
        $this->requireAuth();
        $id = (int) ($_GET['id'] ?? 0);
        if (!$id) {
            $this->redirect('/exercises');
            return;
        }
        $exerciseModel = new Exercise();
        $exercise = $exerciseModel->find($id);
        if (!$exercise) {
            $this->redirect('/exercises');
            return;
        }
        if (!empty($exercise['target_muscles'])) $exercise['target_muscles'] = json_decode($exercise['target_muscles'], true);
        if (!empty($exercise['equipment'])) $exercise['equipment'] = json_decode($exercise['equipment'], true);
        $commentModel = new Comment();
        $comments = $commentModel->getForTarget('exercise', $id);
        $this->view('exercises/show', [
            'title' => $exercise['name'],
            'exercise' => $exercise,
            'comments' => $comments,
        ]);
    }
}
