<?php

declare(strict_types=1);

namespace Controllers;

use Models\ProgressLog;
use Models\WorkoutPlan;

class ProgressController extends BaseController
{
    public function index(): void
    {
        $userId = $this->requireAuth();
        $logModel = new ProgressLog();
        $logs = $logModel->getByUserId($userId, 100);
        $stats = $logModel->getStatsForUser($userId);

        $this->view('progress/index', [
            'title' => 'Progress Log',
            'logs' => $logs,
            'stats' => $stats,
        ]);
    }

    public function log(): void
    {
        $userId = $this->requireAuth();
        $logModel = new ProgressLog();
        $planModel = new WorkoutPlan();

        $date = $_POST['workout_date'] ?? date('Y-m-d');
        $completed = isset($_POST['completed']) && $_POST['completed'] === '1';
        $planId = !empty($_POST['plan_id']) ? (int) $_POST['plan_id'] : null;
        $difficultyRating = isset($_POST['difficulty_rating']) ? (int) $_POST['difficulty_rating'] : null;
        $notes = trim($_POST['notes'] ?? '');

        if ($planId) {
            $plan = $planModel->find($planId);
            if (!$plan || (int) $plan['user_id'] !== $userId) $planId = null;
        }

        $existing = $logModel->getByUserAndDate($userId, $date);
        if ($existing) {
            $logModel->update((int) $existing['id'], [
                'plan_id' => $planId,
                'completed' => $completed ? 1 : 0,
                'difficulty_rating' => $difficultyRating,
                'notes' => $notes,
            ]);
        } else {
            $logModel->create($userId, $date, $completed, $planId, $difficultyRating, $notes ?: null);
        }

        $this->redirect('/progress?logged=1');
    }

    public function showLogForm(): void
    {
        $userId = $this->requireAuth();
        $planModel = new WorkoutPlan();
        $plans = $planModel->getByUserId($userId);

        $this->view('progress/log', [
            'title' => 'Log Workout',
            'plans' => $plans,
        ]);
    }
}
