<?php

declare(strict_types=1);

namespace Controllers;

use Models\Reminder;

class ReminderController extends BaseController
{
    public function index(): void
    {
        $userId = $this->requireAuth();
        try {
            $reminderModel = new Reminder();
            $reminders = $reminderModel->getUpcomingForUser($userId, 30);
            $today = $reminderModel->getTodayForUser($userId);
        } catch (\Throwable $e) {
            $reminders = [];
            $today = [];
        }
        $this->view('reminders/index', [
            'title' => 'Reminders',
            'reminders' => $reminders,
            'today' => $today,
        ]);
    }

    public function dismiss(): void
    {
        $userId = $this->requireAuth();
        $id = (int) ($_POST['id'] ?? 0);
        if ($id) {
            $reminderModel = new Reminder();
            $reminderModel->dismiss($id, $userId);
        }
        $this->redirect($_POST['redirect'] ?? '/reminders');
    }
}
