<?php

declare(strict_types=1);

namespace Models;

class Comment extends Model
{
    protected string $table = 'comments';

    public function getForTarget(string $targetType, int $targetId): array
    {
        $stmt = $this->db->prepare("
            SELECT c.*, u.email
            FROM {$this->table} c
            JOIN users u ON u.id = c.user_id
            WHERE c.target_type = ? AND c.target_id = ?
            ORDER BY c.created_at ASC
        ");
        $stmt->execute([$targetType, $targetId]);
        return $stmt->fetchAll();
    }

    public function add(int $userId, string $targetType, int $targetId, string $body): int
    {
        return $this->insert([
            'user_id' => $userId,
            'target_type' => $targetType,
            'target_id' => $targetId,
            'body' => $body,
        ]);
    }

    public function getAllPaginated(int $limit = 50, int $offset = 0): array
    {
        $stmt = $this->db->prepare("
            SELECT c.*, u.email
            FROM {$this->table} c
            JOIN users u ON u.id = c.user_id
            ORDER BY c.created_at DESC
            LIMIT ? OFFSET ?
        ");
        $stmt->execute([$limit, $offset]);
        return $stmt->fetchAll();
    }

    public function countAll(): int
    {
        $stmt = $this->db->query("SELECT COUNT(*) FROM {$this->table}");
        return (int) $stmt->fetchColumn();
    }
}
