<?php

declare(strict_types=1);

namespace Models;

class Profile extends Model
{
    protected string $table = 'profiles';

    public function findByUserId(int $userId): ?array
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE user_id = ?");
        $stmt->execute([$userId]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function createOrUpdate(int $userId, array $data): int
    {
        $existing = $this->findByUserId($userId);
        $payload = [
            'user_id' => $userId,
            'age' => $data['age'] ?? null,
            'gender' => $data['gender'] ?? null,
            'fitness_level' => isset($data['fitness_level']) ? (int) $data['fitness_level'] : null,
            'health_conditions' => $data['health_conditions'] ?? null,
            'goals' => isset($data['goals']) ? json_encode($data['goals']) : null,
            'preferences' => isset($data['preferences']) ? json_encode($data['preferences']) : null,
            'weekly_time_available' => isset($data['weekly_time_available']) ? (int) $data['weekly_time_available'] : null,
        ];
        if ($existing) {
            unset($payload['user_id']);
            $this->update((int) $existing['id'], $payload);
            return (int) $existing['id'];
        }
        return $this->insert($payload);
    }

    public function getByUserId(int $userId): ?array
    {
        $row = $this->findByUserId($userId);
        if ($row) {
            if (!empty($row['goals'])) $row['goals'] = json_decode($row['goals'], true);
            if (!empty($row['preferences'])) $row['preferences'] = json_decode($row['preferences'], true);
        }
        return $row;
    }
}
