<?php

declare(strict_types=1);

namespace Models;

class User extends Model
{
    protected string $table = 'users';

    public function findByEmail(string $email): ?array
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE email = ?");
        $stmt->execute([$email]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function create(string $email, string $password, string $role = 'user'): int
    {
        $hash = password_hash($password, PASSWORD_BCRYPT, ['cost' => 12]);
        $data = ['email' => $email, 'password' => $hash];
        if ($this->hasColumn('role')) {
            $data['role'] = $role;
        }
        return $this->insert($data);
    }

    public function isAdmin(int $userId): bool
    {
        $user = $this->find($userId);
        return $user && isset($user['role']) && $user['role'] === 'admin';
    }

    private function hasColumn(string $col): bool
    {
        $stmt = $this->db->query("SHOW COLUMNS FROM {$this->table} LIKE " . $this->db->quote($col));
        return $stmt->rowCount() > 0;
    }

    public function verifyPassword(string $email, string $password): ?array
    {
        $user = $this->findByEmail($email);
        if (!$user || !password_verify($password, $user['password'])) {
            return null;
        }
        unset($user['password']);
        return $user;
    }
}
