<?php

declare(strict_types=1);

namespace Models;

class WorkoutPlan extends Model
{
    protected string $table = 'workout_plans';

    public function getByUserId(int $userId, ?string $status = null): array
    {
        if ($status) {
            $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE user_id = ? AND status = ? ORDER BY generated_at DESC");
            $stmt->execute([$userId, $status]);
        } else {
            $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE user_id = ? ORDER BY generated_at DESC");
            $stmt->execute([$userId]);
        }
        return $stmt->fetchAll();
    }

    public function getActiveByUserId(int $userId): ?array
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE user_id = ? AND status = 'active' ORDER BY generated_at DESC LIMIT 1");
        $stmt->execute([$userId]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public function create(int $userId, int $durationWeeks = 4, ?string $startDate = null): int
    {
        $startDate = $startDate ?? date('Y-m-d');
        return $this->insert([
            'user_id' => $userId,
            'start_date' => $startDate,
            'duration_weeks' => $durationWeeks,
            'status' => 'active',
        ]);
    }

    public function setStatus(int $id, string $status): bool
    {
        return $this->update($id, ['status' => $status]);
    }
}
