<?php
/**
 * One-time debug script. Open in browser: http://127.0.0.1/nessa/public/debug.php
 * Delete this file after fixing the 500 error.
 */
error_reporting(E_ALL);
ini_set('display_errors', '1');
header('Content-Type: text/html; charset=utf-8');

echo "<h1>Debug</h1>";
echo "<p>PHP version: " . PHP_VERSION . "</p>";
echo "<p>Document root: " . ($_SERVER['DOCUMENT_ROOT'] ?? '') . "</p>";
echo "<p>SCRIPT_NAME: " . ($_SERVER['SCRIPT_NAME'] ?? '') . "</p>";
echo "<p>REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? '') . "</p>";

$base = dirname(__DIR__);
echo "<p>Project base path: " . htmlspecialchars($base) . "</p>";
echo "<p>Bootstrap exists: " . (is_file($base . '/includes/bootstrap.php') ? 'yes' : 'no') . "</p>";
echo "<p>config/Database.php exists: " . (is_file($base . '/config/Database.php') ? 'yes' : 'no') . "</p>";
echo "<p>config/database.php (lowercase) exists: " . (is_file($base . '/config/database.php') ? 'yes' : 'no') . "</p>";

echo "<h2>Try bootstrap + route</h2>";
try {
    require_once $base . '/includes/bootstrap.php';
    require_once $base . '/includes/autoload.php';
    echo "<p>Bootstrap and autoload OK.</p>";
    $path = '/login';
    $handler = [Controllers\AuthController::class, 'showLogin'];
    [$class, $action] = $handler;
    ob_start();
    (new $class())->$action();
    $out = ob_get_clean();
    echo "<p>Login page length: " . strlen($out) . " bytes. First 200 chars:</p><pre>" . htmlspecialchars(substr($out, 0, 200)) . "...</pre>";
} catch (Throwable $e) {
    echo "<p style='color:red'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}
