<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-slate-900">Exercises</h1>
    <a href="<?= $base ?>/admin/exercises/create" class="px-4 py-2 bg-brand-600 text-white rounded-lg font-medium hover:bg-brand-500">Add Exercise</a>
</div>

<?php if (isset($_GET['updated'])): ?>
<div class="mb-4 p-4 bg-green-50 text-green-800 rounded-lg">Saved.</div>
<?php endif; ?>

<div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
    <table class="min-w-full divide-y divide-slate-200">
        <thead class="bg-slate-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Name</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Difficulty</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Target / Equipment</th>
                <th class="px-6 py-3 text-right text-xs font-medium text-slate-500 uppercase">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-slate-200">
            <?php foreach ($exercises as $e): ?>
            <tr>
                <td class="px-6 py-4 font-medium text-slate-900"><?= htmlspecialchars($e['name']) ?></td>
                <td class="px-6 py-4 text-slate-600"><?= htmlspecialchars($e['difficulty'] ?? '') ?></td>
                <td class="px-6 py-4 text-slate-600 text-sm">
                    <?php
                    $muscles = is_array($e['target_muscles'] ?? null) ? $e['target_muscles'] : [];
                    $equip = is_array($e['equipment'] ?? null) ? $e['equipment'] : [];
                    echo htmlspecialchars(implode(', ', array_slice($muscles, 0, 2)) . (count($equip) ? ' · ' . implode(', ', array_slice($equip, 0, 2)) : ''));
                    ?>
                </td>
                <td class="px-6 py-4 text-right">
                    <a href="<?= $base ?>/admin/exercises/edit?id=<?= (int)$e['id'] ?>" class="text-brand-600 hover:underline mr-3">Edit</a>
                    <form method="post" action="<?= $base ?>/admin/exercises/delete" class="inline" onsubmit="return confirm('Delete this exercise?');">
                        <input type="hidden" name="id" value="<?= (int)$e['id'] ?>">
                        <button type="submit" class="text-red-600 hover:underline">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
