<div class="mb-6">
    <h1 class="text-2xl font-bold text-slate-900">Users</h1>
    <p class="text-slate-600 mt-1">Registered users</p>
</div>
<div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
    <table class="min-w-full divide-y divide-slate-200">
        <thead class="bg-slate-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Email</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Role</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase">Created</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-slate-200">
            <?php foreach ($users as $u): ?>
            <tr>
                <td class="px-6 py-4 text-slate-600"><?= (int)$u['id'] ?></td>
                <td class="px-6 py-4 font-medium text-slate-900"><?= htmlspecialchars($u['email']) ?></td>
                <td class="px-6 py-4"><span class="px-2 py-0.5 rounded text-xs <?= ($u['role'] ?? '') === 'admin' ? 'bg-amber-100 text-amber-800' : 'bg-slate-100 text-slate-600' ?>"><?= htmlspecialchars($u['role'] ?? 'user') ?></span></td>
                <td class="px-6 py-4 text-slate-600 text-sm"><?= date('M j, Y', strtotime($u['created_at'] ?? 'now')) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
