<div class="min-h-screen gradient-bg flex items-center justify-center px-4 py-12">
    <div class="w-full max-w-md">
        <div class="text-center mb-8">
            <span class="inline-flex w-14 h-14 rounded-2xl bg-brand-600 items-center justify-center text-2xl font-bold text-white">W</span>
            <h1 class="mt-4 text-2xl font-bold text-white">Workout Plan Generator</h1>
            <p class="mt-2 text-slate-400">Sign in to your account</p>
        </div>
        <div class="bg-slate-800/80 backdrop-blur rounded-2xl border border-slate-700/50 shadow-xl p-8">
            <?php if (isset($_GET['error'])): ?>
            <div class="mb-4 p-3 rounded-lg text-sm <?= $_GET['error'] === 'invalid' ? 'bg-red-500/20 text-red-300 border border-red-500/30' : 'bg-amber-500/20 text-amber-300 border border-amber-500/30' ?>">
                <?php
                $err = $_GET['error'] ?? '';
                if ($err === 'invalid') echo 'Invalid email or password.';
                elseif ($err === 'missing') echo 'Please enter email and password.';
                else echo 'Please try again.';
                ?>
            </div>
            <?php endif; ?>
            <form method="post" action="<?= $base ?>/login" class="space-y-5">
                <div>
                    <label for="email" class="block text-sm font-medium text-slate-300 mb-1">Email</label>
                    <input type="email" id="email" name="email" required autocomplete="email"
                           class="w-full px-4 py-3 rounded-xl bg-slate-900/80 border border-slate-600 text-white placeholder-slate-500 focus:ring-2 focus:ring-brand-500 focus:border-brand-500"
                           placeholder="you@example.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                </div>
                <div>
                    <label for="password" class="block text-sm font-medium text-slate-300 mb-1">Password</label>
                    <input type="password" id="password" name="password" required autocomplete="current-password"
                           class="w-full px-4 py-3 rounded-xl bg-slate-900/80 border border-slate-600 text-white placeholder-slate-500 focus:ring-2 focus:ring-brand-500 focus:border-brand-500"
                           placeholder="••••••••">
                </div>
                <button type="submit" class="w-full py-3 rounded-xl bg-brand-600 hover:bg-brand-500 text-white font-semibold transition">
                    Sign in
                </button>
            </form>
            <p class="mt-6 text-center text-slate-400 text-sm">
                Don't have an account? <a href="<?= $base ?>/register" class="text-brand-400 hover:text-brand-300 font-medium">Register</a>
            </p>
        </div>
    </div>
</div>
