<div class="space-y-8">
    <h1 class="text-2xl font-bold text-white">Exercise Library</h1>

    <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3" x-data="{ filter: 'all' }">
        <div class="sm:col-span-2 lg:col-span-3 flex flex-wrap gap-2">
            <button @click="filter = 'all'" :class="filter === 'all' ? 'bg-brand-600 text-white' : 'bg-slate-700 text-slate-300 hover:bg-slate-600'"
                    class="px-3 py-1.5 rounded-lg text-sm font-medium transition">All</button>
            <button @click="filter = 'beginner'" :class="filter === 'beginner' ? 'bg-brand-600 text-white' : 'bg-slate-700 text-slate-300 hover:bg-slate-600'"
                    class="px-3 py-1.5 rounded-lg text-sm font-medium transition">Beginner</button>
            <button @click="filter = 'intermediate'" :class="filter === 'intermediate' ? 'bg-brand-600 text-white' : 'bg-slate-700 text-slate-300 hover:bg-slate-600'"
                    class="px-3 py-1.5 rounded-lg text-sm font-medium transition">Intermediate</button>
            <button @click="filter = 'advanced'" :class="filter === 'advanced' ? 'bg-brand-600 text-white' : 'bg-slate-700 text-slate-300 hover:bg-slate-600'"
                    class="px-3 py-1.5 rounded-lg text-sm font-medium transition">Advanced</button>
        </div>
        <?php foreach ($exercises as $ex): ?>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-5 card-hover"
             x-show="filter === 'all' || filter === '<?= htmlspecialchars($ex['difficulty']) ?>'"
             x-transition>
            <div class="flex items-start justify-between gap-2">
                <h3 class="font-semibold text-white">
                    <a href="<?= $base ?>/exercises/show?id=<?= (int)$ex['id'] ?>" class="hover:text-brand-400"><?= htmlspecialchars($ex['name']) ?></a>
                </h3>
                <span class="shrink-0 px-2 py-0.5 rounded text-xs font-medium
                    <?= $ex['difficulty'] === 'beginner' ? 'bg-brand-500/20 text-brand-400' : ($ex['difficulty'] === 'intermediate' ? 'bg-amber-500/20 text-amber-400' : 'bg-red-500/20 text-red-400') ?>">
                    <?= htmlspecialchars($ex['difficulty']) ?>
                </span>
            </div>
            <?php if (!empty($ex['description'])): ?>
            <p class="mt-2 text-slate-400 text-sm line-clamp-2"><?= htmlspecialchars($ex['description']) ?></p>
            <?php endif; ?>
            <?php
            $muscles = is_array($ex['target_muscles'] ?? null) ? $ex['target_muscles'] : [];
            $equip = is_array($ex['equipment'] ?? null) ? $ex['equipment'] : [];
            ?>
            <?php if (!empty($muscles) || !empty($equip)): ?>
            <div class="mt-3 flex flex-wrap gap-1.5">
                <?php foreach (array_slice($muscles, 0, 3) as $m): ?>
                <span class="px-2 py-0.5 rounded bg-slate-700/50 text-slate-300 text-xs"><?= htmlspecialchars($m) ?></span>
                <?php endforeach; ?>
                <?php foreach (array_slice($equip, 0, 2) as $e): ?>
                <span class="px-2 py-0.5 rounded bg-slate-600/50 text-slate-400 text-xs"><?= htmlspecialchars($e) ?></span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
    </div>
</div>
