<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <h1 class="text-2xl font-bold text-white">My Workout Plans</h1>
        <form method="post" action="<?= $base ?>/plans/generate" class="flex flex-wrap items-center gap-3">
            <label for="duration_weeks" class="text-slate-400 text-sm">Duration (weeks)</label>
            <select id="duration_weeks" name="duration_weeks" class="px-3 py-2 rounded-xl bg-slate-800 border border-slate-600 text-white text-sm focus:ring-2 focus:ring-brand-500">
                <?php for ($w = 2; $w <= 12; $w++): ?>
                <option value="<?= $w ?>" <?= $w === 4 ? 'selected' : '' ?>><?= $w ?></option>
                <?php endfor; ?>
            </select>
            <button type="submit" class="px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-semibold transition">Generate New Plan</button>
        </form>
    </div>

    <?php if (empty($plans)): ?>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-12 text-center">
        <p class="text-slate-400">No plans yet.</p>
        <p class="text-slate-500 text-sm mt-1">Fill your profile, then generate a plan tailored to you.</p>
        <a href="<?= $base ?>/profile/edit" class="inline-block mt-4 px-4 py-2 rounded-xl bg-slate-700 hover:bg-slate-600 text-white text-sm font-medium transition">Edit Profile</a>
        <span class="mx-2 text-slate-500">or</span>
        <form method="post" action="<?= $base ?>/plans/generate" class="inline">
            <input type="hidden" name="duration_weeks" value="4">
            <button type="submit" class="px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">Generate Plan</button>
        </form>
    </div>
    <?php else: ?>
    <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
        <?php foreach ($plans as $p): ?>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden card-hover">
            <div class="p-5">
                <span class="inline-block px-2 py-0.5 rounded text-xs font-medium
                    <?= $p['status'] === 'active' ? 'bg-brand-500/20 text-brand-400' : ($p['status'] === 'completed' ? 'bg-slate-500/20 text-slate-400' : 'bg-slate-600/20 text-slate-500') ?>">
                    <?= htmlspecialchars($p['status']) ?>
                </span>
                <p class="mt-2 font-semibold text-white"><?= date('M j, Y', strtotime($p['generated_at'])) ?></p>
                <p class="text-slate-400 text-sm"><?= (int)$p['duration_weeks'] ?> weeks · Start <?= date('M j', strtotime($p['start_date'])) ?></p>
            </div>
            <div class="px-5 pb-5 flex flex-wrap gap-2">
                <a href="<?= $base ?>/plans?id=<?= (int)$p['id'] ?>" class="px-3 py-1.5 rounded-lg bg-slate-700 hover:bg-slate-600 text-white text-sm font-medium transition">View</a>
                <?php if ($p['status'] !== 'active'): ?>
                <form method="post" action="<?= $base ?>/plans/status" class="inline">
                    <input type="hidden" name="plan_id" value="<?= (int)$p['id'] ?>">
                    <input type="hidden" name="status" value="active">
                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-brand-600/80 hover:bg-brand-500 text-white text-sm font-medium transition">Set Active</button>
                </form>
                <?php endif; ?>
                <?php if ($p['status'] === 'active'): ?>
                <form method="post" action="<?= $base ?>/plans/status" class="inline">
                    <input type="hidden" name="plan_id" value="<?= (int)$p['id'] ?>">
                    <input type="hidden" name="status" value="completed">
                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-slate-600 hover:bg-slate-500 text-slate-300 text-sm font-medium transition">Mark Completed</button>
                </form>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>
