<?php
$plan = $plan ?? null;
$byDay = $byDay ?? [];
?>
<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <a href="<?= $base ?>/plans" class="text-slate-400 hover:text-white text-sm mb-2 inline-block">← Back to plans</a>
            <h1 class="text-2xl font-bold text-white">Workout Plan</h1>
            <p class="text-slate-400 text-sm mt-0.5">
                <?= date('M j, Y', strtotime($plan['generated_at'])) ?> · <?= (int)$plan['duration_weeks'] ?> weeks · Start <?= date('M j, Y', strtotime($plan['start_date'])) ?>
            </p>
        </div>
        <span class="inline-block px-3 py-1 rounded-lg text-sm font-medium
            <?= $plan['status'] === 'active' ? 'bg-brand-500/20 text-brand-400' : 'bg-slate-500/20 text-slate-400' ?>">
            <?= htmlspecialchars($plan['status']) ?>
        </span>
    </div>

    <?php if (empty($byDay)): ?>
    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-8 text-center text-slate-400">
        No exercises in this plan.
    </div>
    <?php else: ?>
    <div class="space-y-8">
        <?php foreach ($byDay as $dayNum => $exercises): ?>
        <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-700/50 bg-slate-800/80 flex flex-wrap items-center justify-between gap-4">
                <h2 class="font-semibold text-white">Day <?= (int)$dayNum ?></h2>
                <a href="<?= $base ?>/plans/start?plan_id=<?= (int)$plan['id'] ?>&day=<?= (int)$dayNum ?>" class="px-3 py-1.5 rounded-lg bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium">Start workout</a>
            </div>
            <ul class="divide-y divide-slate-700/50">
                <?php foreach ($exercises as $pe): ?>
                <li class="p-5 flex flex-col sm:flex-row sm:items-center gap-4">
                    <div class="flex-1 min-w-0">
                        <h3 class="font-medium text-white"><?= htmlspecialchars($pe['exercise_name']) ?></h3>
                        <?php if (!empty($pe['description'])): ?>
                        <p class="text-slate-400 text-sm mt-0.5 line-clamp-2"><?= htmlspecialchars($pe['description']) ?></p>
                        <?php endif; ?>
                        <?php
                        $muscles = is_array($pe['target_muscles'] ?? null) ? $pe['target_muscles'] : [];
                        if (!empty($muscles)):
                        ?>
                        <div class="mt-2 flex flex-wrap gap-1">
                            <?php foreach ($muscles as $m): ?>
                            <span class="px-2 py-0.5 rounded bg-slate-700/50 text-slate-400 text-xs"><?= htmlspecialchars($m) ?></span>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="flex flex-wrap gap-3 shrink-0 text-sm">
                        <span class="px-2 py-1 rounded bg-slate-700/50 text-slate-300"><?= (int)$pe['sets'] ?> sets</span>
                        <span class="px-2 py-1 rounded bg-slate-700/50 text-slate-300"><?= htmlspecialchars($pe['reps']) ?> reps</span>
                        <?php if (!empty($pe['intensity'])): ?>
                        <span class="px-2 py-1 rounded bg-slate-700/50 text-slate-300"><?= htmlspecialchars($pe['intensity']) ?></span>
                        <?php endif; ?>
                        <span class="px-2 py-1 rounded bg-slate-700/50 text-slate-400"><?= (int)$pe['rest_seconds'] ?>s rest</span>
                    </div>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>
