<?php
$profile = $profile ?? null;
$goals = is_array($profile['goals'] ?? null) ? $profile['goals'] : [];
$preferences = is_array($profile['preferences'] ?? null) ? $profile['preferences'] : [];
?>
<div class="space-y-8">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <h1 class="text-2xl font-bold text-white">My Profile</h1>
        <a href="<?= $base ?>/profile/edit" class="inline-flex items-center px-4 py-2 rounded-xl bg-brand-600 hover:bg-brand-500 text-white text-sm font-medium transition">Edit Profile</a>
    </div>

    <?php if (isset($_GET['updated'])): ?>
    <div class="p-4 rounded-xl bg-brand-500/20 text-brand-300 border border-brand-500/30">Profile updated.</div>
    <?php endif; ?>

    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden">
        <div class="p-6 space-y-6">
            <?php if (!$profile): ?>
            <p class="text-slate-400">No profile yet. <a href="<?= $base ?>/profile/edit" class="text-brand-400 hover:underline">Create one</a>.</p>
            <?php else: ?>
            <div class="grid gap-6 sm:grid-cols-2">
                <div>
                    <p class="text-slate-500 text-sm">Age</p>
                    <p class="text-white font-medium"><?= $profile['age'] !== null ? (int)$profile['age'] : '—' ?></p>
                </div>
                <div>
                    <p class="text-slate-500 text-sm">Gender</p>
                    <p class="text-white font-medium"><?= $profile['gender'] ? htmlspecialchars(ucfirst($profile['gender'])) : '—' ?></p>
                </div>
                <div>
                    <p class="text-slate-500 text-sm">Fitness level (1–5)</p>
                    <p class="text-white font-medium"><?= $profile['fitness_level'] !== null ? (int)$profile['fitness_level'] : '—' ?></p>
                </div>
                <div>
                    <p class="text-slate-500 text-sm">Weekly time (minutes)</p>
                    <p class="text-white font-medium"><?= $profile['weekly_time_available'] !== null ? (int)$profile['weekly_time_available'] : '—' ?></p>
                </div>
            </div>
            <?php if (!empty($profile['health_conditions'])): ?>
            <div>
                <p class="text-slate-500 text-sm">Health conditions</p>
                <p class="text-white"><?= nl2br(htmlspecialchars($profile['health_conditions'])) ?></p>
            </div>
            <?php endif; ?>
            <?php if (!empty($goals)): ?>
            <div>
                <p class="text-slate-500 text-sm">Goals</p>
                <ul class="flex flex-wrap gap-2 mt-1">
                    <?php foreach ($goals as $g): ?>
                    <span class="px-2 py-1 rounded-lg bg-brand-500/20 text-brand-300 text-sm"><?= htmlspecialchars($g) ?></span>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
            <?php if (!empty($preferences)): ?>
            <div>
                <p class="text-slate-500 text-sm">Preferences</p>
                <ul class="flex flex-wrap gap-2 mt-1">
                    <?php foreach ($preferences as $pr): ?>
                    <span class="px-2 py-1 rounded-lg bg-slate-600/30 text-slate-300 text-sm"><?= htmlspecialchars($pr) ?></span>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
