<?php $plans = $plans ?? []; ?>
<div class="space-y-8 max-w-xl">
    <h1 class="text-2xl font-bold text-white">Log Workout</h1>

    <form method="post" action="<?= $base ?>/progress/log" class="bg-slate-800/60 rounded-2xl border border-slate-700/50 p-6 space-y-5">
        <div>
            <label for="workout_date" class="block text-sm font-medium text-slate-300 mb-1">Date</label>
            <input type="date" id="workout_date" name="workout_date" required value="<?= date('Y-m-d') ?>"
                   class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
        </div>
        <div>
            <label for="plan_id" class="block text-sm font-medium text-slate-300 mb-1">Plan (optional)</label>
            <select id="plan_id" name="plan_id" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
                <option value="">— None —</option>
                <?php foreach ($plans as $p): ?>
                <option value="<?= (int)$p['id'] ?>"><?= date('M j, Y', strtotime($p['generated_at'])) ?> (<?= $p['status'] ?>)</option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-300 mb-2">Completed?</label>
            <div class="flex gap-4">
                <label class="flex items-center gap-2 cursor-pointer">
                    <input type="radio" name="completed" value="1" class="rounded-full border-slate-600 text-brand-500 focus:ring-brand-500">
                    <span class="text-slate-300">Yes</span>
                </label>
                <label class="flex items-center gap-2 cursor-pointer">
                    <input type="radio" name="completed" value="0" checked class="rounded-full border-slate-600 text-brand-500 focus:ring-brand-500">
                    <span class="text-slate-300">No</span>
                </label>
            </div>
        </div>
        <div>
            <label for="difficulty_rating" class="block text-sm font-medium text-slate-300 mb-1">Difficulty (1–5, optional)</label>
            <select id="difficulty_rating" name="difficulty_rating" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500">
                <option value="">—</option>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                <option value="<?= $i ?>"><?= $i ?></option>
                <?php endfor; ?>
            </select>
        </div>
        <div>
            <label for="notes" class="block text-sm font-medium text-slate-300 mb-1">Notes (optional)</label>
            <textarea id="notes" name="notes" rows="3" class="w-full px-4 py-2.5 rounded-xl bg-slate-900/80 border border-slate-600 text-white focus:ring-2 focus:ring-brand-500 focus:border-brand-500" placeholder="How did it feel?"></textarea>
        </div>
        <button type="submit" class="w-full py-3 rounded-xl bg-brand-600 hover:bg-brand-500 text-white font-semibold transition">Save Log</button>
    </form>
</div>
