<div class="space-y-8">
    <h1 class="text-2xl font-bold text-white">Reminders</h1>

    <?php if (!empty($today)): ?>
    <div class="bg-brand-500/20 border border-brand-500/40 rounded-2xl p-6">
        <h2 class="font-semibold text-brand-300 mb-4">Today</h2>
        <ul class="space-y-3">
            <?php foreach ($today as $r): ?>
            <li class="flex items-center justify-between gap-4 bg-slate-800/50 rounded-xl p-4">
                <div>
                    <p class="font-medium text-white"><?= htmlspecialchars($r['title']) ?></p>
                    <?php if (!empty($r['message'])): ?>
                    <p class="text-slate-400 text-sm mt-0.5"><?= htmlspecialchars($r['message']) ?></p>
                    <?php endif; ?>
                    <p class="text-slate-500 text-xs mt-1"><?= date('g:i A', strtotime($r['remind_at'])) ?></p>
                </div>
                <form method="post" action="<?= $base ?>/reminders/dismiss">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <input type="hidden" name="redirect" value="<?= $base ?>/reminders">
                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-slate-700 hover:bg-slate-600 text-slate-300 text-sm">Dismiss</button>
                </form>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="bg-slate-800/60 rounded-2xl border border-slate-700/50 overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-700/50">
            <h2 class="font-semibold text-white">Upcoming</h2>
        </div>
        <?php if (empty($reminders)): ?>
        <div class="p-8 text-center text-slate-400">No upcoming reminders. Generate a plan to get automatic workout reminders.</div>
        <?php else: ?>
        <ul class="divide-y divide-slate-700/50">
            <?php foreach ($reminders as $r): ?>
            <li class="px-6 py-4 flex items-center justify-between gap-4">
                <div>
                    <p class="font-medium text-white"><?= htmlspecialchars($r['title']) ?></p>
                    <p class="text-slate-400 text-sm"><?= date('D, M j, Y \a\t g:i A', strtotime($r['remind_at'])) ?></p>
                </div>
                <form method="post" action="<?= $base ?>/reminders/dismiss">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <input type="hidden" name="redirect" value="<?= $base ?>/reminders">
                    <button type="submit" class="text-slate-500 hover:text-slate-300 text-sm">Dismiss</button>
                </form>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php endif; ?>
    </div>
</div>
